/**
 * Folder tree for WP Media Folder
 */
var wpmfGalleryTreeModule;
(function ($) {
    /**
     * Main folder tree function
     * @type {{options: {root: string, showroot: string, onclick: onclick, oncheck: oncheck, usecheckboxes: boolean, expandSpeed: number, collapseSpeed: number, expandEasing: null, collapseEasing: null, canselect: boolean}, init: init, glropengallery, glrclosedir: glrclosedir, glrsetevents: glrsetevents}}
     */
    wpmfGalleryTreeModule = {
        options: {
            'root': '/',
            'showroot': '',
            'onclick': function (elem, type, file) {
            },
            'oncheck': function (elem, checked, type, file) {
            },
            'usecheckboxes': true, //can be true files dirs or false
            'expandSpeed': 500,
            'collapseSpeed': 500,
            'expandEasing': null,
            'collapseEasing': null,
            'canselect': true
        },
        categories : [], // categories
        folders_states : [], // Contains open or closed status of galleries
        /**
         * Folder tree init
         */
        init: function () {
            wpmfGalleryTreeModule.categories_order = wpmf_glraddon.vars.categories_order;
            wpmfGalleryTreeModule.categories = wpmf_glraddon.vars.categories;

            wpmfGalleryTreeModule.importCategories();
            $gallerylist = $('.gallerylist');
            if ($gallerylist.length === 0) {
                return;
            }

            wpmfGalleryTreeModule.loadTreeView();
            var data_params = $('#gallerylist').data('edited');
            var first_id = data_params.gallery_id;
            if (parseInt(first_id) === 0) {
                first_id = $('#gallerylist').find('.tree_view ul li:nth-child(2)').data('id');
            }

            if (first_id !== 0) {
                $('.wpmf-gallery-tree-item[data-id="'+ first_id +'"]').parents('li').removeClass('closed');
                wpmfGalleryTreeModule.glrTitleopengallery(first_id);
            }

            wpmfGalleryModule.galleryEvent();
            wpmfGalleryTreeModule.dragGallery($(".tree_view ul"));
            wpmfGalleryTreeModule.dropGallery();
        },

        loadTreeView: function () {
            wpmfGalleryTreeModule.getTreeElement().html(wpmfGalleryTreeModule.getRendering());
            wpmfGalleryTreeModule.initContainerResizing();
            wpmfGalleryTreeModule.getTreeElement().scrollbar();
            $(window).on('resize', function () {
                wpmfGalleryTreeModule.initContainerResizing();
            });

            $(document).on('wp-collapse-menu', function (state) {
                wpmfGalleryTreeModule.initContainerResizing();
            });
        },

        /**
         * import gallery category
         */
        importCategories: function () {
            var galleries_ordered = [];

            // Add each category
            $(wpmfGalleryTreeModule.categories_order).each(function (i, v) {
                galleries_ordered.push(wpmfGalleryTreeModule.categories[this]);
            });
            galleries_ordered = galleries_ordered.sort(function(a, b){return a.order - b.order});
            // Reorder array based on children
            var galleries_ordered_deep = [];
            var processed_ids = [];
            const loadChildren = function (id) {
                if (processed_ids.indexOf(id) < 0) {
                    processed_ids.push(id);
                    for (var ij = 0; ij < galleries_ordered.length; ij++) {
                        if (galleries_ordered[ij].parent_id === id) {
                            galleries_ordered_deep.push(galleries_ordered[ij]);
                            loadChildren(galleries_ordered[ij].id);
                        }
                    }
                }
            };
            loadChildren(0);

            // Finally save it to the global var
            wpmfGalleryTreeModule.categories = galleries_ordered_deep;
            if (wpmfGalleryTreeModule.categories.length <= 1) {
                $('.form_edit_gallery').hide();
            } else {
                $('.form_edit_gallery').show();
            }
        },

        /**
         * Get the html resulting tree view
         * @return {string}
         */
        getRendering: function () {
            var ij = 0;
            var content = ''; // Final tree view content
            /**
             * Recursively print list of folders
             * @return {boolean}
             */
            const generateList = function () {
                content += '<ul>';
                var lists = wpmfGalleryTreeModule.categories;
                while (ij < lists.length) {
                    var className = 'closed';
                    // Open li tag
                    content += '<li class="' + className + '" data-id="' + lists[ij].id + '">';
                    var pad = lists[ij].depth * 28;
                    content += '<div class="wpmf-gallery-tree-item" data-id="' + lists[ij].id + '" data-parent_id="' + lists[ij].parent_id + '">';
                    content += '<div class="wpmf-gallery-item-inside" data-id="' + lists[ij].id + '" style="padding-left: ' + pad + 'px">';
                    var a_tag = '<a class="wpmf-gallery-text-item" data-id="' + lists[ij].id + '">';

                    if (lists[ij + 1] && lists[ij + 1].depth > lists[ij].depth) {
                        // The next element is a sub folder
                        content += '<a class="wpmf-gallery-toggle-icon" onclick="wpmfGalleryTreeModule.toggle(' + lists[ij].id + ')"><i class="tree_arrow_right_icon wpmf-gallery-arrow"></i></a>';
                        content += a_tag;
                    } else {
                        content += '<a class="wpmf-gallery-toggle-icon wpmf-gallery-notoggle-icon"><i class="tree_arrow_right_icon"></i></a>';
                        content += a_tag;
                    }

                    // Add folder icon
                    if (parseInt(lists[ij].id) === 0) {
                        content += '<i class="wpmf-gallery-item-icon wpmf-gallery-item-icon-root"></i>';
                    } else {
                        if (typeof lists[ij].feature_image !== "undefined" && lists[ij].feature_image !== '') {
                            content += '<img class="wpmf-gallery-thumbnail-icon" src="'+ lists[ij].feature_image +'">';
                        } else {
                            content += '<img class="wpmf-gallery-thumbnail-icon wpmf-gallery-thumbnail-icon-default" src="'+ wpmf_glraddon.vars.plugin_url_image +'image-gallery-icon.png">';
                        }
                    }
                    content += '<span class="wpmf-gallery-item-title">' + lists[ij].label + '</span>';

                    content += '</a>';
                    content += '</div></div>';
                    // This is the end of the array
                    if (lists[ij + 1] === undefined) {
                        // Let's close all opened tags
                        for (var ik = lists[ij].depth; ik >= 0; ik--) {
                            content += '</li>';
                            content += '</ul>';
                        }

                        // We are at the end don't continue to process array
                        return false;
                    }

                    if (lists[ij + 1].depth > lists[ij].depth) {
                        // The next element is a sub folder
                        // Recursively list it
                        ij++;
                        if (generateList() === false) {
                            // We have reached the end, let's recursively end
                            return false;
                        }
                    } else if (lists[ij + 1].depth < lists[ij].depth) {
                        // The next element don't have the same parent
                        // Let's close opened tags
                        for (var _ik = lists[ij].depth; _ik > lists[ij + 1].depth; _ik--) {
                            content += '</li>';
                            content += '</ul>';
                        }

                        // We're not at the end of the array let's continue processing it
                        return true;
                    }

                    // Close the current element
                    content += '</li>';
                    ij++;
                }
            };

            // Start generation
            generateList('wpmf_media_library');
            return content;
        },

        /**
         * Initialize folder tree resizing
         */
        initContainerResizing: function() {
            var window_width = $(window).width();
            if (window_width <= 768) {
                return;
            }
            var is_resizing = false;
            $(window).on('resize', function () {
                wpmfGalleryTreeModule.getTreeElement().scrollbar();
            });
            // Main upload.php page
            var $main = $('#wpbody');
            var $tree = $('.gallerylist');
            var $right_min_width = 500;
            var $tree_min_width = 300;

            var $handle = $('<div class="gallerylist-resize"></div>').appendTo($tree);
            $handle.on('mousedown', function (e) {
                is_resizing = true;
                $('body').css('user-select', 'none'); // prevent content selection while moving
            });

            var tree_width = parseInt(wpmfGalleryTreeModule.getCookie('wpmf-gallery-tree-size'));
            if (tree_width < $tree_min_width) tree_width = $tree_min_width;
            var right_width = $main.width() - tree_width;
            if (right_width < $right_min_width) {
                right_width = $right_min_width;
                tree_width = $main.width() - $right_min_width;
            }

            if (window_width > 1024 && right_width < 850) {
                $('.WpmfGalleryList').addClass('wpmf-small-right-screen');
            } else {
                $('.WpmfGalleryList').removeClass('wpmf-small-right-screen');
            }

            if (typeof tree_width !== "undefined" && parseFloat(tree_width) > 0) {
                $tree.css({ 'width': parseFloat(tree_width) + 'px' });
                if ($('body').hasClass('media_page_media-folder-galleries')) {
                    $('.form_edit_gallery').css({'width': (right_width + 20) + 'px', 'margin-left': tree_width + 'px'});
                } else {
                    $('.form_edit_gallery').css({'width': right_width + 'px', 'margin-left': tree_width + 'px'});
                }
            }

            $(document).on('mousemove', function (e) {
                // we don't want to do anything if we aren't resizing.
                if (!is_resizing) return;

                // Calculate tree width
                var tree_width = parseInt(e.clientX - $tree.offset().left);
                if (tree_width < $tree_min_width) tree_width = $tree_min_width;
                var right_width = $main.width() - tree_width;
                if (right_width < $right_min_width) {
                    right_width = $right_min_width;
                    tree_width = $main.width() - $right_min_width;
                }

                if (window_width > 1024 && right_width < 850) {
                    $('.WpmfGalleryList').addClass('wpmf-small-right-screen');
                } else {
                    $('.WpmfGalleryList').removeClass('wpmf-small-right-screen');
                }

                $tree.css('width', tree_width + 'px');
                // We have to set margin if we are in a fixed tree position or in list page
                if ($('body').hasClass('media_page_media-folder-galleries')) {
                    $('.form_edit_gallery').css({'width': (right_width + 20) + 'px', 'margin-left': tree_width + 'px'});
                } else {
                    $('.form_edit_gallery').css({'width': right_width + 'px', 'margin-left': tree_width + 'px'});
                }
                wpmfGalleryTreeModule.setCookie('wpmf-gallery-tree-size', tree_width, 365);
            }).on('mouseup', function (e) {
                if (is_resizing) {
                    // stop resizing
                    is_resizing = false;
                    $('body').css('user-select', '');
                    $(window).trigger('resize');
                }
            });
        },

        /**
         * get a cookie
         * @param cname cookie name
         * @returns {*}
         */
        getCookie: function(cname) {
            let name = cname + "=";
            let ca = document.cookie.split(';');
            for (let i = 0; i < ca.length; i++) {
                let c = ca[i];
                while (c.charAt(0) === ' ') {
                    c = c.substring(1);
                }
                if (c.indexOf(name) === 0) {
                    return c.substring(name.length, c.length);
                }
            }
            return "";
        },

        /**
         * set a cookie
         * @param cname cookie name
         * @param cvalue cookie value
         * @param exdays
         */
        setCookie: function(cname, cvalue, exdays) {
            var d = new Date();
            d.setTime(d.getTime() + exdays * 24 * 60 * 60 * 1000);
            var expires = "expires=" + d.toUTCString();
            document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
        },

        /**
         * Toggle the open / closed state of a gallery
         * @param gallery_id
         */
        toggle : function(gallery_id) {
            // Check is gallery has closed class
            if (wpmfGalleryTreeModule.getTreeElement().find('li[data-id="' + gallery_id + '"]').hasClass('closed')) {
                // Open the gallery
                wpmfGalleryTreeModule.glropengallery(gallery_id);
            } else {
                // Close the gallery
                wpmfGalleryTreeModule.glrclosedir(gallery_id);
                // close all sub gallery
                $('li[data-id="' + gallery_id + '"]').find('li').addClass('closed');
            }
        },

        /**
         * open gallery tree by dir name
         * @param gallery_id
         */
        glropengallery : function(gallery_id) {
            wpmfGalleryTreeModule.getTreeElement().find('li[data-id="' + gallery_id + '"]').removeClass('closed');
            wpmfGalleryTreeModule.folders_states[gallery_id] = 'open';
        },

        /**
         * open gallery tree by dir name
         */
        glrTitleopengallery : function(gallery_id, reload = false) {
            if (parseInt(gallery_id) === 0 || (wpmfGalleryModule.wpmf_current_gallery === gallery_id && !reload)) {
                return;
            }

            wpmfGalleryTreeModule.getTreeElement().find('li').removeClass('selected');
            wpmfGalleryTreeModule.getTreeElement().find('li[data-id="' + gallery_id + '"]').removeClass('closed').addClass('selected');
            wpmfGalleryTreeModule.folders_states[gallery_id] = 'open';
            wpmfGalleryModule.changeGallery(gallery_id);

            wpmfGalleryModule.wpmf_current_gallery = gallery_id;
            $('.select_gallery_id').val(gallery_id);
        },

        /**
         * Close a gallery and hide children
         * @param gallery_id
         */
        glrclosedir : function(gallery_id) {
            wpmfGalleryTreeModule.getTreeElement().find('li[data-id="' + gallery_id + '"]').addClass('closed');
            wpmfGalleryTreeModule.folders_states[gallery_id] = 'close';
        },

        /**
         * Retrieve the Jquery tree view element
         * of the current frame
         * @return jQuery
         */
        getTreeElement : function() {
            return $('.tree_view');
        },

        /**
         * init event click to open/close gallery tree
         */
        deleteGallery: function (id) {
            /* Delete gallery */
            showDialog({
                title: wpmf_glraddon.l18n.delete_gallery,
                negative: {
                    title: wpmf_glraddon.l18n.cancel
                },
                positive: {
                    title: wpmf_glraddon.l18n.delete,
                    onClick: function () {
                        $.ajax({
                            type: "POST",
                            url: ajaxurl,
                            data: {
                                action: "wpmfgallery",
                                task: "delete_gallery",
                                id: id,
                                wpmf_gallery_nonce: wpmf_glraddon.vars.wpmf_gallery_nonce
                            },
                            success: function (res) {
                                /* remove gallery html */
                                if (res.status) {
                                    $('#gallerylist').find('[data-id="' + id + '"]').remove();
                                    $('.wpmf-gallery-categories option[value="' + id + '"]').remove();
                                    var first_id = $('#gallerylist').find('.tree_view ul li:nth-child(2)').data('id');
                                    wpmfGalleryTreeModule.glrTitleopengallery(first_id);

                                    /* display notification */
                                    wpmfSnackbarModule.show({
                                        id: 'gallery_deleted',
                                        content : wpmf_glraddon.l18n.delete_glr,
                                        auto_close_delay: 2000
                                    });
                                }
                            }
                        });
                    }
                }
            });
        },

        /**
         * droppable Gallery
         */
        dropGallery: function () {
            // Initialize dropping gallery on tree view
            wpmfGalleryTreeModule.getTreeElement().find('ul li .wpmf-gallery-tree-item').droppable({
                hoverClass: "wpmf-gallery-drag-hover",
                tolerance: 'pointer',
                over: function (event, ui) {
                    $('.tree_view ul').sortable('disable');
                    $('.wpmfgallery_drop_sort').hide();
                },
                out: function (event, ui) {
                    $('.tree_view ul').sortable('enable');
                    $('.wpmfgallery_drop_sort').show();
                },
                drop: function (event, ui) {
                    event.stopPropagation();
                    $(ui.helper).addClass('wpmf_gallery_dragout wpmf_gallery_transition');
                    // Transfer the event to the wpmf main module
                    var parent = $(this).data('id');
                    var id_gallery = $(ui.draggable).closest('li').data('id');
                    $.ajax({
                        type: "POST",
                        url: ajaxurl,
                        data: {
                            action: "wpmfgallery",
                            task: "update_parent_gallery",
                            parent: parent,
                            id_gallery: id_gallery,
                            wpmf_gallery_nonce: wpmf_glraddon.vars.wpmf_gallery_nonce
                        },
                        success: function (response) {
                            /* remove gallery html */
                            if (response.status) {
                                // update dropdown lists gallery
                                $('#wpmf-gallery-categories').remove();
                                $('.gallery_theme').after(response.dropdown_gallery);

                                // Update the categories variables
                                wpmfGalleryModule.renderListstree(response, wpmfGalleryModule.wpmf_current_gallery, false);
                            }
                        }
                    });
                }
            });
        },

        /**
         * draggable gallery
         */
        dragGallery: function ($tree) {
            $tree.sortable({
                placeholder: 'wpmfgallery_drop_sort',
                items: 'li:not([data-id="0"])',
                revert: true,
                cursorAt: {top: 0, left: 0},
                appendTo: '.gallerylist',
                helper: function (ui) {
                    var helper = '<div class="wpmf-move-gallery">';
                    helper += '<span class="mdc-list-item__start-detail" role="presentation"><i class="material-icons wpmf-icon-category">folder</i></span>';
                    helper += '<span class="mdc-list-item__text"> '+ wpmf_glraddon.l18n.moving_text +' </span>';
                    helper += '</div>';
                    return helper;
                },
                delay: 100, // Prevent dragging when only trying to click
                distance: 10,
                /** Prevent firefox bug positionnement **/
                start: function (event, ui) {

                },
                stop: function (event, ui) {
                },
                beforeStop: function (event, ui) {
                    var userAgent = navigator.userAgent.toLowerCase();
                    $(ui.helper).addClass('wpmf_gallery_transition');
                    if (ui.offset !== "undefined" && userAgent.match(/firefox/)) {
                        ui.helper.css('margin-top', 0);
                    }
                },
                update: function () {
                    var order = '';
                    $.each($('.tree_view li'), function (i, val) {
                        var id = $(val).data('id');
                        if (id !== 0) {
                            if (order !== '') {
                                order += ',';
                            }
                            order += '"' + i + '":' + id;
                        }
                    });
                    order = '{' + order + '}';

                    // do re-order gallery
                    $.ajax({
                        type: "POST",
                        url: ajaxurl,
                        data: {
                            action: "wpmfgallery",
                            task: "reordergallery",
                            order: order,
                            wpmf_gallery_nonce: wpmf_glraddon.vars.wpmf_gallery_nonce
                        },
                        success: function (res) {
                            // Show snackbar
                            wpmfSnackbarModule.show({
                                id: 'reorder_gallery',
                                content : wpmf_glraddon.l18n.reordergallery,
                                auto_close : true
                            });
                        }
                    });
                }
            });

            $tree.disableSelection();
        }
    };

    // initialize WPMF gallery tree features
    $(document).ready(function () {
        wpmfGalleryTreeModule.init();
    });
})(jQuery);


