/* global fusionAppConfig, FusionPageBuilderViewManager, imagesLoaded */
/* jshint -W098 */
/* eslint no-unused-vars: 0 */
var FusionPageBuilder = FusionPageBuilder || {};

(function () {
    /**
     * run masonry layout
     */
    function wpmfGalleryAddonAvadaInitSlider($container, params) {
        var columns = parseInt(params.columns);
        var gutterwidth = params.gutterwidth;
        var autoplay = 0;
        if (jQuery().wpmfflexslider) {
            imagesLoaded($container, function () {
                var container_width = $container.width();
                var columns_width = (container_width - (columns - 1) * gutterwidth) / columns;
                /* call flexslider function */
                $container.wpmfflexslider({
                    animation: 'slide',
                    animationLoop: true,
                    slideshow: (autoplay === 1),
                    smoothHeight: (columns === 1),
                    itemWidth: (columns === 1) ? 0 : columns_width,
                    itemMargin: (columns === 1) ? 0 : gutterwidth,
                    pauseOnHover: true,
                    slideshowSpeed: 5000,
                    prevText: "",
                    nextText: ""
                });
                $container.css('max-width', (container_width) + 'px');
                setTimeout(function () {
                    $container.find('.wpmf-gallery-item').css({
                        'width': columns_width + 'px',
                        'max-width': columns_width + 'px'
                    });
                }, 120);
            });
        }
    }

    function wpmfGalleryAddonAvadaInitMasonry($container) {
        var $grid = $container.isotope({
            itemSelector: '.wpmf-gallery-item',
            percentPosition: true,
            layoutMode: 'packery',
            resizable: true,
            initLayout: true
        });

        // layout Isotope after each image loads
        $grid.find('.wpmf-gallery-item').imagesLoaded().progress( function() {
            setTimeout(function () {
                $grid.isotope('layout');
                $grid.find('.wpmf-gallery-item').addClass('masonry-brick');
            },200);
        });
    }

    function wpmfAvadaInitFlowsSlide($container) {
        imagesLoaded($container, function () {
            var enableNavButtons = $container.data('button');
            if (typeof enableNavButtons !== "undefined" && parseInt(enableNavButtons) === 1) {
                $container.flipster({
                    style: 'coverflow',
                    buttons: 'custom',
                    spacing: 0,
                    loop: true,
                    autoplay: 5000,
                    buttonNext: '<i class="flipto-next material-icons"> keyboard_arrow_right </i>',
                    buttonPrev: '<i class="flipto-prev material-icons"> keyboard_arrow_left </i>',
                    onItemSwitch: function (currentItem, previousItem) {
                        $container.find('.flipster__container').height(jQuery(currentItem).height());
                    },
                    onItemStart: function (currentItem) {
                        $container.find('.flipster__container').height(jQuery(currentItem).height());
                    }
                });
            } else {
                $container.flipster({
                    style: 'coverflow',
                    spacing: 0,
                    loop: true,
                    autoplay: 5000,
                    onItemSwitch: function (currentItem, previousItem) {
                        $container.find('.flipster__container').height(jQuery(currentItem).height());
                    },
                    onItemStart: function (currentItem) {
                        $container.find('.flipster__container').height(jQuery(currentItem).height());
                    }
                });
            }
        });
    }
    
    jQuery(document).ready(function () {
        var wpmfGalleryAddonElementSettingsView = FusionPageBuilder.ElementSettingsView;
        FusionPageBuilder.ElementSettingsView = FusionPageBuilder.ElementSettingsView.extend({
            optionChanged: function(event) {
                wpmfGalleryAddonElementSettingsView.prototype.optionChanged.apply(this, arguments);
                var wrap = this.$el;
                var element_type = this.model.attributes.element_type;
                var $target    = jQuery( event.target ),
                    $option    = $target.closest( '.fusion-builder-option' ),
                    paramName;
                paramName  = this.getParamName($target, $option);
                if (element_type === 'wpmf_fusion_gallery_addon') {
                    if (paramName === 'gallery_id') {
                        var title = wrap.find('.wpmf_fusion_gallery_addon li[data-option-id="gallery_id"] .fusion-option-selected').html();
                        title = title.replace(/[--]/g, '');
                        this.elementView.changeParam('gallery_title', title );
                    }
                }
            }
        });

        FusionPageBuilder.wpmf_fusion_gallery_addon = FusionPageBuilder.ElementView.extend({
            onRender: function () {
                this.afterPatch();
            },

            beforePatch: function() {
                var container = this.$el;
                var masonry_container = container.find('.wpmf_gallery_wrap');
                masonry_container.remove();
            },

            afterPatch: function() {
                var container = this.$el;
                var params = this.model.attributes.params;
                container.find('.loading_gallery').hide();
                if (parseInt(params.gallery_id) !== 0) {
                    var masonry_container = container.find('.gallery-masonry');
                    if (masonry_container.length) {
                        if (masonry_container.find('.wpmf-gallery-item').length) {
                            wpmfGalleryAddonAvadaInitMasonry(masonry_container);
                        }
                    }

                    var slider_container = container.find('.gallery_addon_flexslider');
                    if (slider_container.length) {
                        wpmfGalleryAddonAvadaInitSlider(slider_container, params);
                    }

                    var flowslider_container = container.find('.flipster');
                    if (flowslider_container.length) {
                        wpmfAvadaInitFlowsSlide(flowslider_container);
                    }
                }
            }
        });
    });
}(jQuery));
